<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\FlexApi\V1\Interaction;

use Twilio\Exceptions\TwilioException;
use Twilio\InstanceResource;
use Twilio\Options;
use Twilio\Rest\FlexApi\V1\Interaction\InteractionChannel\InteractionChannelInviteList;
use Twilio\Rest\FlexApi\V1\Interaction\InteractionChannel\InteractionChannelParticipantList;
use Twilio\Values;
use Twilio\Version;

/**
 * @property string $sid
 * @property string $interactionSid
 * @property string $type
 * @property string $status
 * @property int $errorCode
 * @property string $errorMessage
 * @property string $url
 * @property array $links
 */
class InteractionChannelInstance extends InstanceResource {
    protected $_invites;
    protected $_participants;

    /**
     * Initialize the InteractionChannelInstance
     *
     * @param Version $version Version that contains the resource
     * @param mixed[] $payload The response payload
     * @param string $interactionSid The unique string that identifies the resource.
     * @param string $sid The unique string that identifies the resource
     */
    public function __construct(Version $version, array $payload, string $interactionSid, string $sid = null) {
        parent::__construct($version);

        // Marshaled Properties
        $this->properties = [
            'sid' => Values::array_get($payload, 'sid'),
            'interactionSid' => Values::array_get($payload, 'interaction_sid'),
            'type' => Values::array_get($payload, 'type'),
            'status' => Values::array_get($payload, 'status'),
            'errorCode' => Values::array_get($payload, 'error_code'),
            'errorMessage' => Values::array_get($payload, 'error_message'),
            'url' => Values::array_get($payload, 'url'),
            'links' => Values::array_get($payload, 'links'),
        ];

        $this->solution = ['interactionSid' => $interactionSid, 'sid' => $sid ?: $this->properties['sid'], ];
    }

    /**
     * Generate an instance context for the instance, the context is capable of
     * performing various actions.  All instance actions are proxied to the context
     *
     * @return InteractionChannelContext Context for this InteractionChannelInstance
     */
    protected function proxy(): InteractionChannelContext {
        if (!$this->context) {
            $this->context = new InteractionChannelContext(
                $this->version,
                $this->solution['interactionSid'],
                $this->solution['sid']
            );
        }

        return $this->context;
    }

    /**
     * Fetch the InteractionChannelInstance
     *
     * @return InteractionChannelInstance Fetched InteractionChannelInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetch(): InteractionChannelInstance {
        return $this->proxy()->fetch();
    }

    /**
     * Update the InteractionChannelInstance
     *
     * @param string $status Required. The Interaction channels's status
     * @param array|Options $options Optional Arguments
     * @return InteractionChannelInstance Updated InteractionChannelInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function update(string $status, array $options = []): InteractionChannelInstance {
        return $this->proxy()->update($status, $options);
    }

    /**
     * Access the invites
     */
    protected function getInvites(): InteractionChannelInviteList {
        return $this->proxy()->invites;
    }

    /**
     * Access the participants
     */
    protected function getParticipants(): InteractionChannelParticipantList {
        return $this->proxy()->participants;
    }

    /**
     * Magic getter to access properties
     *
     * @param string $name Property to access
     * @return mixed The requested property
     * @throws TwilioException For unknown properties
     */
    public function __get(string $name) {
        if (\array_key_exists($name, $this->properties)) {
            return $this->properties[$name];
        }

        if (\property_exists($this, '_' . $name)) {
            $method = 'get' . \ucfirst($name);
            return $this->$method();
        }

        throw new TwilioException('Unknown property: ' . $name);
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $context = [];
        foreach ($this->solution as $key => $value) {
            $context[] = "$key=$value";
        }
        return '[Twilio.FlexApi.V1.InteractionChannelInstance ' . \implode(' ', $context) . ']';
    }
}