export default {
  props: {
    color: String
  },
  methods: {
    addBackgroundColorClassChecks: function addBackgroundColorClassChecks(classes) {
      var prop = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'color';

      if (this[prop]) {
        classes[this[prop]] = true;
      }
      return classes;
    },
    addTextColorClassChecks: function addTextColorClassChecks(classes) {
      var prop = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'color';

      var parts = this[prop] ? this[prop].trim().split(' ') : [''];
      var color = parts[0] + '--text';
      if (parts.length > 1) color += ' text--' + parts[1];
      classes[color] = !!this[prop];
      return classes;
    }
  }
};