require('../../../src/stylus/components/_tabs.styl');

import Themeable from '../../mixins/themeable';
import Resize from '../../directives/resize';

export default {
  name: 'v-tabs',

  directives: {
    Resize: Resize
  },

  mixins: [Themeable],

  provide: function provide() {
    var _this = this;

    return {
      registerContent: this.registerContent,
      unregisterContent: this.unregisterContent,
      registerTabItem: this.registerTabItem,
      unregisterTabItem: this.unregisterTabItem,
      next: this.next,
      prev: this.prev,
      slider: this.slider,
      tabClick: this.tabClick,
      isScrollable: function isScrollable() {
        return _this.scrollable;
      },
      isMobile: function isMobile() {
        return _this.isMobile;
      }
    };
  },
  data: function data() {
    return {
      content: [],
      tabItems: [],
      activeIndex: null,
      isBooted: false,
      isMobile: false,
      resizeTimeout: null,
      reverse: false,
      target: null,
      tabsSlider: null,
      targetEl: null,
      tabsContainer: null,
      transitionTime: 300
    };
  },


  props: {
    centered: Boolean,
    fixed: Boolean,
    grow: Boolean,
    icons: Boolean,
    mobileBreakPoint: {
      type: [Number, String],
      default: 1280
    },
    value: String,
    scrollable: {
      type: Boolean,
      default: true
    }
  },

  computed: {
    classes: function classes() {
      return {
        'tabs': true,
        'tabs--centered': this.centered,
        'tabs--fixed': this.fixed,
        'tabs--grow': this.grow,
        'tabs--icons': this.icons,
        'tabs--mobile': this.isMobile,
        'tabs--scroll-bars': this.scrollable,
        'theme--dark': this.dark,
        'theme--light': this.light
      };
    }
  },

  watch: {
    value: function value() {
      this.tabClick(this.value);
    },
    activeIndex: function activeIndex() {
      var _this2 = this;

      this.updateTabs();
      this.$nextTick(function () {
        return _this2.isBooted = true;
      });
    },
    tabItems: function tabItems(newItems, oldItems) {
      var _this3 = this;

      // Tab item got removed
      if (oldItems.length > newItems.length) {
        if (!newItems.find(function (o) {
          return o.id === _this3.target;
        })) {
          var i = oldItems.findIndex(function (o) {
            return o.id === _this3.target;
          });

          this.$nextTick(function () {
            _this3.activeIndex = _this3.tabItems[i > 0 ? i - 1 : 0].id;
            _this3.target = _this3.activeIndex;
          });
        }
      }
      this.slider();
    },
    '$vuetify.application.left': function $vuetifyApplicationLeft() {
      this.onContainerResize();
    },
    '$vuetify.application.right': function $vuetifyApplicationRight() {
      this.onContainerResize();
    }
  },

  mounted: function mounted() {
    var _this4 = this;

    this.$vuetify.load(function () {
      // // This is a workaround to detect if link is active
      // // when being used as a router or nuxt link
      var i = _this4.tabItems.findIndex(function (_ref) {
        var el = _ref.el;

        return el.firstChild.classList.contains('tabs__item--active');
      });

      var tab = _this4.value || (_this4.tabItems[i !== -1 ? i : 0] || {}).id;

      tab && _this4.tabClick(tab) && _this4.onResize();
    });
  },


  methods: {
    registerContent: function registerContent(id, toggle) {
      this.content.push({ id: id, toggle: toggle });
    },
    registerTabItem: function registerTabItem(id, toggle, el) {
      this.tabItems.push({ id: id, toggle: toggle, el: el });
    },
    unregisterContent: function unregisterContent(id) {
      this.content = this.content.filter(function (o) {
        return o.id !== id;
      });
    },
    unregisterTabItem: function unregisterTabItem(id) {
      this.tabItems = this.tabItems.filter(function (o) {
        return o.id !== id;
      });
    },
    next: function next(cycle) {
      var nextIndex = this.activeIndex + 1;

      if (!this.content[nextIndex]) {
        if (!cycle) return;
        nextIndex = 0;
      }

      this.tabClick(this.tabItems[nextIndex].id);
    },
    prev: function prev(cycle) {
      var prevIndex = this.activeIndex - 1;

      if (!this.content[prevIndex]) {
        if (!cycle) return;
        prevIndex = this.content.length - 1;
      }

      this.tabClick(this.tabItems[prevIndex].id);
    },
    onResize: function onResize() {
      this.isMobile = window.innerWidth < this.mobileBreakPoint;
      this.slider();
    },

    /**
     * When v-navigation-drawer changes the
     * width of the container, call resize
     * after the transition is complete
     * 
     * @return {Void}
     */
    onContainerResize: function onContainerResize() {
      clearTimeout(this.resizeTimeout);
      this.resizeTimeout = setTimeout(this.onResize, this.transitionTime);
    },
    slider: function slider(el) {
      var _this5 = this;

      this.tabsSlider = this.tabsSlider || this.$el.querySelector('.tabs__slider');

      this.tabsContainer = this.tabsContainer || this.$el.querySelector('.tabs__container');

      if (!this.tabsSlider || !this.tabsContainer) return;

      this.targetEl = el || this.targetEl;

      if (!this.targetEl) return;

      // Gives DOM time to paint when
      // processing slider for
      // dynamic tabs
      this.$nextTick(function () {
        // #684 Calculate width as %
        var width = _this5.targetEl.scrollWidth / _this5.tabsContainer.clientWidth * 100;

        _this5.tabsSlider.style.width = width + '%';
        _this5.tabsSlider.style.left = _this5.targetEl.offsetLeft + 'px';
      });
    },
    tabClick: function tabClick(target) {
      var _this6 = this;

      var setActiveIndex = function setActiveIndex(index) {
        if (_this6.activeIndex === index) {
          // #762 update tabs display
          // In case tabs count got changed but activeIndex didn't
          _this6.updateTabs();
        } else {
          _this6.activeIndex = index;
        }
      };

      this.target = target;

      this.$nextTick(function () {
        var nextIndex = _this6.content.findIndex(function (o) {
          return o.id === target;
        });
        _this6.reverse = nextIndex < _this6.activeIndex;
        setActiveIndex(nextIndex);

        _this6.$emit('input', _this6.target);
      });
    },
    updateTabs: function updateTabs() {
      var _this7 = this;

      this.content.forEach(function (_ref2) {
        var toggle = _ref2.toggle;

        toggle(_this7.target, _this7.reverse, _this7.isBooted);
      });

      this.tabItems.forEach(function (_ref3) {
        var toggle = _ref3.toggle;

        toggle(_this7.target);
      });
    }
  },

  render: function render(h) {
    return h('div', {
      'class': this.classes,
      directives: [{
        name: 'resize',
        value: this.onResize
      }]
    }, this.$slots.default);
  }
};