require('../../../src/stylus/components/_input-groups.styl');
require('../../../src/stylus/components/_selection-controls.styl');
require('../../../src/stylus/components/_radio-group.styl');

import Input from '../../mixins/input';

export default {
  name: 'v-radio-group',

  mixins: [Input],

  model: {
    prop: 'inputValue',
    event: 'change'
  },

  provide: function provide() {
    var _this = this;

    return {
      isMandatory: function isMandatory() {
        return _this.mandatory;
      },
      name: function name() {
        return _this.name;
      },
      registerChild: this.registerChild,
      unregisterChild: this.unregisterChild
    };
  },


  props: {
    column: {
      type: Boolean,
      default: true
    },
    inputValue: null,
    mandatory: {
      type: Boolean,
      default: true
    },
    name: String,
    row: Boolean
  },

  data: function data() {
    return {
      internalTabIndex: -1
    };
  },


  watch: {
    inputValue: function inputValue(val) {
      this.getRadios().forEach(function (radio) {
        radio.isActive = val === radio.value;
      });
    }
  },

  computed: {
    classes: function classes() {
      return {
        'radio-group': true,
        'radio-group--column': this.column && !this.row,
        'radio-group--row': this.row
      };
    }
  },

  methods: {
    getRadios: function getRadios() {
      return this.$children.filter(function (child) {
        return child.$el.classList.contains('radio');
      });
    },
    toggleRadio: function toggleRadio(value) {
      var _this2 = this;

      if (this.disabled) {
        return;
      }

      this.shouldValidate = true;
      this.$emit('change', value);
      this.$nextTick(function () {
        return _this2.validate();
      });

      this.getRadios().filter(function (r) {
        return r.value !== value;
      }).forEach(function (r) {
        return r.isActive = false;
      });
    },
    radioBlur: function radioBlur(e) {
      if (!e.relatedTarget || !e.relatedTarget.classList.contains('radio')) {
        this.shouldValidate = true;
        this.$emit('blur', this.inputValue);
      }
    },
    registerChild: function registerChild(radio) {
      radio.isActive = this.inputValue === radio.value;
      radio.$el.tabIndex = radio.$el.tabIndex > 0 ? radio.$el.tabIndex : 0;
      radio.$on('change', this.toggleRadio);
      radio.$on('blur', this.radioBlur);
      radio.$on('focus', this.radioFocus);
    },
    unregisterChild: function unregisterChild(radio) {
      radio.$off('change', this.toggleRadio);
      radio.$off('blur', this.radioBlur);
      radio.$off('focus', this.radioFocus);
    }
  },

  mounted: function mounted() {
    var _this3 = this;

    this.getRadios().forEach(function (radio) {
      return _this3.registerChild(radio);
    });
  },
  beforeDestroy: function beforeDestroy() {
    var _this4 = this;

    this.getRadios().forEach(function (radio) {
      return _this4.unregisterChild(radio);
    });
  },
  render: function render(h) {
    var data = {
      attrs: {
        role: 'radiogroup'
      }
    };
    return this.genInputGroup(this.$slots.default, data);
  }
};