export default {
  methods: {
    genYears: function genYears() {
      return this.$createElement('ul', {
        staticClass: 'picker--date__years',
        key: 'year',
        ref: 'years'
      }, this.genYearItems());
    },
    yearClick: function yearClick(year) {
      var _this = this;

      this.inputDate = this.normalizeDate(year, this.tableMonth, this.day);

      if (this.type === 'year') {
        this.$nextTick(function () {
          return _this.autosave && _this.save();
        });
      } else {
        this.activePicker = 'MONTH';
      }
    },
    genYearItems: function genYearItems() {
      var _this2 = this;

      var children = [];

      var _loop = function _loop(year, length) {
        var date = _this2.normalizeDate(year, _this2.month, _this2.day);
        var buttonText = _this2.supportsLocaleFormat ? date.toLocaleDateString(_this2.locale, {
          year: 'numeric',
          timeZone: _this2.timeZone
        }) : year;

        children.push(_this2.$createElement('li', {
          'class': {
            active: _this2.year === year
          },
          on: {
            click: function click() {
              return _this2.yearClick(year);
            }
          }
        }, buttonText));
      };

      for (var year = this.year + 100, length = this.year - 100; year > length; year--) {
        _loop(year, length);
      }
      return children;
    }
  }
};