export default {
  methods: {
    genBtn: function genBtn(change, children) {
      var _this = this;

      return this.$createElement('v-btn', {
        props: {
          dark: this.dark,
          icon: true
        },
        nativeOn: {
          click: function click(e) {
            e.stopPropagation();
            if (_this.activePicker === 'DATE') {
              _this.tableDate = _this.normalizeDate(_this.tableYear, change);
            } else if (_this.activePicker === 'MONTH') {
              _this.tableDate = _this.normalizeDate(change, _this.tableMonth);
            }
          }
        }
      }, children);
    },
    genHeader: function genHeader(keyValue, selectorText) {
      var _this2 = this;

      var header = this.$createElement('strong', {
        key: keyValue,
        on: {
          click: function click() {
            return _this2.activePicker = _this2.activePicker === 'DATE' ? 'MONTH' : 'YEAR';
          }
        }
      }, selectorText);

      var transition = this.$createElement('transition', {
        props: { name: this.computedTransition }
      }, [header]);

      return this.$createElement('div', {
        'class': 'picker--date__header-selector-date'
      }, [transition]);
    },
    genSelector: function genSelector() {
      var keyValue = this.activePicker === 'DATE' ? this.tableMonth : this.tableYear;
      var selectorDate = this.normalizeDate(this.tableYear, this.tableMonth);

      var selectorText = '';
      if (typeof this.headerDateFormat === 'function' && this.activePicker === 'DATE') {
        selectorText = this.headerDateFormat(selectorDate, this.activePicker);
      } else if (this.supportsLocaleFormat) {
        var format = this.activePicker === 'DATE' ? this.headerDateFormat : { year: 'numeric' };
        selectorText = selectorDate.toLocaleDateString(this.locale, Object.assign(format, {
          timeZone: this.timeZone
        }));
      } else if (this.activePicker === 'DATE') {
        selectorText = selectorDate.getFullYear() + '/';
        if (selectorDate.getMonth() < 9) selectorText += '0';
        selectorText += 1 + selectorDate.getMonth();
      } else if (this.activePicker === 'MONTH') {
        selectorText = selectorDate.getFullYear();
      }

      return this.$createElement('div', {
        'class': 'picker--date__header-selector'
      }, [this.genBtn(keyValue - 1, [this.$createElement('v-icon', 'chevron_left')]), this.genHeader(keyValue, selectorText), this.genBtn(keyValue + 1, [this.$createElement('v-icon', 'chevron_right')])]);
    }
  }
};