import Routable from '../../mixins/routable';

export default {
  name: 'v-breadcrumbs-item',

  mixins: [Routable],

  inject: ['divider'],

  props: {
    activeClass: {
      type: String,
      default: 'breadcrumbs__item--disabled'
    }
  },

  computed: {
    classes: function classes() {
      var classes = {
        'breadcrumbs__item': true
      };

      classes[this.activeClass] = this.disabled;

      return classes;
    }
  },

  render: function render(h) {
    var _generateRouteLink = this.generateRouteLink(),
        tag = _generateRouteLink.tag,
        data = _generateRouteLink.data;

    return h('li', {
      attrs: { 'data-divider': this.divider }
    }, [h(tag, data, this.$slots.default)]);
  }
};