import { mergeData } from "../../utils";

export var props = {
    tag: {
        type: String,
        default: "ul"
    },
    fill: {
        type: Boolean,
        default: false
    },
    justified: {
        type: Boolean,
        default: false
    }
};

export default {
    functional: true,
    props: props,
    render: function render(h, _ref) {
        var props = _ref.props,
            data = _ref.data,
            children = _ref.children;

        return h(props.tag, mergeData(data, {
            staticClass: "navbar-nav",
            class: {
                "nav-fill": props.fill,
                "nav-justified": props.justified
            }
        }), children);
    }
};