function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

import { mergeData } from "../../utils";
import { arrayIncludes } from "../../utils/array";

var COMMON_ALIGNMENT = ["start", "end", "center"];

export var props = {
    tag: {
        type: String,
        default: "div"
    },
    noGutters: {
        type: Boolean,
        default: false
    },
    alignV: {
        type: String,
        default: null,
        validator: function validator(str) {
            return arrayIncludes(COMMON_ALIGNMENT.concat(["baseline", "stretch"]), str);
        }
    },
    alignH: {
        type: String,
        default: null,
        validator: function validator(str) {
            return arrayIncludes(COMMON_ALIGNMENT.concat(["between", "around"]), str);
        }
    },
    alignContent: {
        type: String,
        default: null,
        validator: function validator(str) {
            return arrayIncludes(COMMON_ALIGNMENT.concat(["between", "around", "stretch"]), str);
        }
    }
};

export default {
    functional: true,
    props: props,
    render: function render(h, _ref) {
        var _class;

        var props = _ref.props,
            data = _ref.data,
            children = _ref.children;

        return h(props.tag, mergeData(data, {
            staticClass: "row",
            class: (_class = {
                "no-gutters": props.noGutters
            }, _defineProperty(_class, "align-items-" + props.alignV, props.alignV), _defineProperty(_class, "justify-content-" + props.alignH, props.alignH), _defineProperty(_class, "align-content-" + props.alignContent, props.alignContent), _class)
        }), children);
    }
};