import { mergeData } from "../../utils";

export var props = {
    id: {
        type: String,
        default: null
    },
    tag: {
        type: String,
        default: "h6"
    }
};

export default {
    functional: true,
    props: props,
    render: function render(h, _ref) {
        var props = _ref.props,
            data = _ref.data,
            children = _ref.children;

        return h(props.tag, mergeData(data, {
            staticClass: "dropdown-header",
            attrs: { id: props.id || null }
        }), children);
    }
};