var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

import { mergeData } from "../../utils";
import { isArray } from "../../utils/array";
import { assign } from "../../utils/object";
import BreadcrumbItem from "./breadcrumb-item";

export var props = {
    items: {
        type: Array,
        default: null
    }
};

export default {
    functional: true,
    props: props,
    render: function render(h, _ref) {
        var props = _ref.props,
            data = _ref.data,
            children = _ref.children;

        var childNodes = children;
        // Build child nodes from items if given.
        if (isArray(props.items)) {
            var activeDefined = false;
            childNodes = props.items.map(function (item, idx) {
                if ((typeof item === "undefined" ? "undefined" : _typeof(item)) !== "object") {
                    item = { text: item };
                }
                // Copy the value here so we can normalize it.
                var active = item.active;
                if (active) {
                    activeDefined = true;
                }
                if (!active && !activeDefined) {
                    // Auto-detect active by position in list.
                    active = idx + 1 === props.items.length;
                }

                return h(BreadcrumbItem, { props: assign({}, item, { active: active }) });
            });
        }

        return h("ol", mergeData(data, { staticClass: "breadcrumb" }), childNodes);
    }
};