
/**
 * First we will load all of this project's JavaScript dependencies which
 * includes Vue and other libraries. It is a great starting point when
 * building robust, powerful web applications using Vue and Laravel.
 */

require('./bootstrap');

window.Vue = require('vue');

/**
 * Next, we will create a fresh Vue application instance and attach it to
 * the page. Then, you may begin adding components to this application
 * or customize the JavaScript scaffolding to fit your unique needs.
 */
Vue.component('v-input', require('./components/vinput.vue'));
Vue.component('table_provider', require('./components/table_provider.vue'));
Vue.component('loading', require('./components/loading.vue'));
Vue.component('pagination', require('./components/pagination.vue'));

const app = new Vue({
    el: '#providers',
    created: function(){
        this.getProviders();
    },
    data: {
        providers: [],
        pagination: {
            'total': 0,
            'current_page': 0,
            'per_page': 0,
            'last_page': 0,
            'from': 0,
            'to': 0,
        },
        newProvider: [],
        errors: [],
        create: true,
        loading: true,
    },
    methods: {
        getProviders: function(page){
            var urlProviders = "api/provider?page="+page;
            this.loading = true;
            axios.get(urlProviders).then(response => {
                this.providers = response.data.providers.data;
                this.pagination = response.data.pagination;
                this.loading = false;
            });
        },
        deleteProvider: function(data){
            var provider = data.provider;
            var url = "api/provider/" + provider.id
            bootbox.confirm("Are you sure do you want delete the provider?", function(result) {
                if(result == true) {
                    axios.delete(url).then(response => {
                        app.getProviders();
                        toastr.success("The provider was successfully removed");
                    });
                }
            }); 
        },
        showForm: function(){
            this.newProvider = [];
            this.create = true;
            this.errors = [];
            jQuery('#create').modal('show');
        },
        executeForm: function(provider){
            if(this.create == true) this.createProvider();
            else this.updateProvider(provider);
                
        },
        createProvider: function(){
           var url = 'api/provider';
           this.errors = [];
            axios.post(url,{
                name: this.newProvider.name,
                email: this.newProvider.email,
                adress: this.newProvider.adress,
                phone_number: this.newProvider.phone_number,
                company_name: this.newProvider.company_name,
            }).then(response => {
                this.getProviders();
                this.newProvider = [];
                this.errors = [];
                jQuery('#create').modal('hide');
                toastr.success("The provider was successfully added");
            }).catch(error => {
                this.errors = error.response.data;
            });
        },
        editProvider: function(data){
            var provider = data.provider;
            this.newProvider = {
                name: provider.name,
                email: provider.email,
                adress: provider.adress,
                phone_number: provider.phone_number,
                company_name: provider.company_name,
                id: provider.id
            };
            this.create = false;
            this.errors = [];
            jQuery('#create').modal('show');
        },
        updateProvider: function(provider){
            var url = "api/provider/" + provider.id;
            axios.put(url,{
                name: this.newProvider.name,
                email: this.newProvider.email,
                adress: this.newProvider.adress,
                phone_number: this.newProvider.phone_number,
                company_name: this.newProvider.company_name,
            }).then(response => {
                this.getProviders(this.pagination.current_page);
                this.newProvider = [];
                this.errors = [];
                jQuery('#create').modal('hide');
                toastr.success("The provider was successfully updated");
            }).catch(error => {
                this.errors = error.response.data;
            });
        },
        changePage: function(data){
            var page = data.page;
            this.pagination.current_page = page;
            this.getProviders(page);
        },
    }
});
