<?php

namespace App\Http\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Setting;
use App\Invoice;
use App\InvoicePayments;
use App\ProviderBills;
use App\Expense;
use App\WorkReports;

class StadisticsController extends Controller
{
    public function getDashboard(){
        //$total_expenses = ProviderBills::sum('total');
        $tax_ = Setting::where("var","tax")->first();
        $date = date("Y-m");
        
        $invoices = Invoice::where("type","invoice")->where("created_at", "like", $date."%")->get();
        $total_sales = 0;
        foreach ($invoices as $invoice) {
            $total_sales += InvoicePayments::where("invoice_id", $invoice->id)->sum("paid");
        }
        $stats =  [
            'stadistics' => [
                'total_estimates' => Invoice::where("type","estimate")->where("created_at", "like", $date."%")->count(),
                'total_invoices' => Invoice::where("type","invoice")->where("created_at", "like", $date."%")->count(),
                //'total_sales' => InvoicePayments::where("created_at", "like", $date."%")->sum('paid'),
                'total_sales' => $total_sales,
                'total_expenses_' => ProviderBills::where("date", "like", $date."%")->sum('total'),
                'total_expenses_v' => Expense::where("type", "Fixed Costs")->sum("amount") + Expense::where("type", "Variable expends")->where("created_at", "like", $date."%")->sum("amount"),
                'total_expenses_salary' => WorkReports::where("status","Paid")->where("date_paid", "like", $date."%")->sum("total"),
            ]
        ];
        
        $tax = 7;
        if($tax_) $tax = $tax_->value;
        $stats['stadistics']['total_tax'] = $stats['stadistics']['total_sales'] * $tax / 100;
        
        $stats['stadistics']['total_expenses'] = $stats['stadistics']['total_expenses_'] + $stats['stadistics']['total_expenses_v'] + $stats['stadistics']['total_expenses_salary'];
        
        $stats['stadistics']['total_benefit'] = $stats['stadistics']['total_sales'] - $stats['stadistics']['total_expenses'] - $stats['stadistics']['total_tax'];
        
        return $stats;
    }
    public function getTable(Request $request){
        
        $tax_ = Setting::where("var","tax")->first();
        $tax = 7;
        $year = date("Y");
        $year = $request->get("year");
        if($tax_) $tax = $tax_->value;
        
        $data ['stadistics'] = [
            "Jan." => [
                "month" => "Jan.",
                "month_number" => "01"
            ],
            "Feb." => [
                "month" => "Feb.",
                "month_number" => "02"
            ],
            "Mar." => [
                "month" => "Mar.",
                "month_number" => "03"
            ],
            "Apr." => [
                "month" => "Apr.",
                "month_number" => "04"
            ],
            "May." => [
                "month" => "May.",
                "month_number" => "05"
            ],
            "Jun." => [
                "month" => "Jun.",
                "month_number" => "06"
            ],
            "Jul." => [
                "month" => "Jul.",
                "month_number" => "07"
            ],
            "Aug." => [
                "month" => "Aug.",
                "month_number" => "08"
            ],
            "Sep." => [
                "month" => "Sep.",
                "month_number" => "09"
            ],
            "Oct." => [
                "month" => "Oct.",
                "month_number" => "10"
            ],
            "Nov." => [
                "month" => "Nov.",
                "month_number" => "11"
            ],
            "Dec." => [
                "month" => "Dec.",
                "month_number" => "12"
            ],
        ];
        $temp = $data['stadistics'];
         $data['stadistics'] = [];
         $total = [
             'balance' => 0,
             'bills_expenses' => 0,
             'variable_expenses' => 0,
             'salary_expenses' => 0,
             'tax' => 0,
             'benefit' => 0
         ];
        foreach ($temp as $item) {
            $date = $year."-".$item["month_number"];
            //$item['balance'] = InvoicePayments::where("created_at", "like", $date."%")->sum('paid');
            
            $invoices = Invoice::where("type","invoice")->where("created_at", "like", $date."%")->get();
            $sum = 0;
            foreach ($invoices as $invoice) {
                //print_r(strpos($invoice->created_at, $date));
                //if(strpos($invoice->created_at, $date) !== FALSE)
                $sum += InvoicePayments::where("invoice_id", $invoice->id)->sum("paid");
            }
            /*$item['paid'] = $sum;
            $item['unpaid'] = $item['balance'] - $item['paid'];*/
            $item['balance'] = $sum;
            $item['bills_expenses'] = ProviderBills::where("date", "like", $date."%")->sum('total');
            
            $item['variable_expenses'] = Expense::where("type", "Fixed Costs")->sum("amount") + Expense::where("type", "Variable expends")->where("created_at", "like", $date."%")->sum("amount");
            
            $item['salary_expenses'] = WorkReports::where("status","Paid")->where("date_paid", "like", $date."%")->sum("total");
            
            $item['tax'] = $item['balance'] * $tax / 100;
            $item['benefit'] = $item['balance'] - ($item['bills_expenses'] + $item['variable_expenses'] + $item['salary_expenses'] + $item['tax']);
            $data ['stadistics'][] = $item;
            
            $total['balance'] += $item['balance'];
            $total['bills_expenses'] += $item['bills_expenses'];
            $total['variable_expenses'] += $item['variable_expenses'];
            $total['salary_expenses'] += $item['salary_expenses'];
            $total['tax'] += $item['tax'];
            $total['benefit'] += $item['benefit'];
        }
        $data['totals'] = $total;
        return $data;
    }
}
