<?php

namespace App\Http\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Provider;

class ProviderController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request){
        $providers = Provider::orderBy('id','DESC')->paginate(25);
        return [
            'pagination' => [
                'total'         => $providers->total(),
                'current_page'  => $providers->currentPage(),
                'per_page'      => $providers->perPage(),
                'last_page'     => $providers->lastPage(),
                'from'          => $providers->firstItem(),
                'to'            => $providers->lastItem(),
            ],
            "providers" => $providers
        ];
    }
    public function getAll(){
        $providers = Provider::with("products")->get();
        return $providers;
    }
    public function search(){
        $providers = Provider::get();
        return $providers;
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request){
        if($request->get('email') != "") {
            $this->validate($request, [
                "name" => 'required',
                "email" => 'unique:providers',
                "adress" => 'required',
                "phone_number" => 'required',
            ]); 
        }
        else {
            $this->validate($request, [
                "name" => 'required',
                //"email" => 'email|unique:providers',
                "adress" => 'required',
                "phone_number" => 'required',
            ]); 
        }
        Provider::create($request->all());
        return;
    }


    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id){
        if($request->get('email') != "") {
            $this->validate($request, [
                "name" => 'required',
                "email" => 'sometimes|email|unique:providers,email,'.$id,
                "adress" => 'required',
                "phone_number" => 'required',
            ]); 
        }
        else {
            $this->validate($request, [
                "name" => 'required',
                //"email" => 'sometimes|email|unique:providers,email,'.$id,
                "adress" => 'required',
                "phone_number" => 'required',
            ]); 
        }
        Provider::find($id)->update($request->all());
        return;
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id){
        try {
            $provider = Provider::findOrFail($id);
            $provider->delete();
            return json_encode(["msg" => "succes"]);
        } catch (\Illuminate\Database\QueryException $ex) {
            return json_encode(["msg" => "error"]);
        }
    }
}