<?php

namespace App\Http\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Invoice;
use App\Setting;
use App\Client;
use App\InvoiceServices;
use App\InvoiceProducts;
use App\InvoicePayments;
use App\Product;

class InvoicesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(){
        $invoices = Invoice::with("client","payments")->where("type", "invoice")->orderBy('number','DESC')->paginate(25);
        return [
            'pagination' => [
                'total'         => $invoices->total(),
                'current_page'  => $invoices->currentPage(),
                'per_page'      => $invoices->perPage(),
                'last_page'     => $invoices->lastPage(),
                'from'          => $invoices->firstItem(),
                'to'            => $invoices->lastItem(),
            ],
            "invoices" => $invoices,
        ];
    }
    public function getAll(){
        $invoices = Invoice::where(["type" => "invoice"])->select(["number as id", "number as name"])->get();
        return $invoices;
    }
    public function search(){
        $invoices = Invoice::with("client","payments")->where(["type" => "invoice"])->orderBy('number','DESC')->get();
        return $invoices;
    }
    public function searchEstimates(){
        $invoices = Invoice::with("client")->where(["type" => "estimate"])->orderBy('id','DESC')->get();
        return $invoices;
    }
    public function invoicest(){
        $invoices = Invoice::with("client", "payments")->where(["type" => "invoice", "h" => "0"])->orderBy('number','DESC')->paginate(10);
        return [
            'pagination' => [
                'total'         => $invoices->total(),
                'current_page'  => $invoices->currentPage(),
                'per_page'      => $invoices->perPage(),
                'last_page'     => $invoices->lastPage(),
                'from'          => $invoices->firstItem(),
                'to'            => $invoices->lastItem(),
            ],
            "invoices" => $invoices,
        ];
    }
    public function estimates(){
        $invoices = Invoice::with("client")->where("type", "estimate")->orderBy('id','DESC')->paginate(10);
        return [
            'pagination' => [
                'total'         => $invoices->total(),
                'current_page'  => $invoices->currentPage(),
                'per_page'      => $invoices->perPage(),
                'last_page'     => $invoices->lastPage(),
                'from'          => $invoices->firstItem(),
                'to'            => $invoices->lastItem(),
            ],
            "invoices" => $invoices,
        ];
    }
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request){
        $this->validate($request, [
            "type" => 'required',
            //"number" => 'required',
            //"deposit" => 'required',
            "subtotal" => 'required',
            //"discount" => 'required',
            //"tax" => 'required',
            "total" => 'required',
        ]);
        $invoice_number = Setting::where("var","invoice_number")->firstOrFail();
        if($invoice = Invoice::create($request->all())) {
            if($invoice->type == "invoice") {
                $invoice->number = $invoice_number->value;
                if($invoice->save()) {
                    $invoice_number->value = $invoice_number->value + 1;
                    $invoice_number->save();
                }
            }
            $info_client = $request->get('client');
            $client = new Client;
            $client->name = $info_client['name'];
            $client->adress = $info_client['adress'];
            $client->city = $info_client['city'];
            $client->state = $info_client['state'];
            $client->zip = $info_client['zip'];
            $client->email = $info_client['email'];
            $client->cell_phome = $info_client['cell_phome'];
            $client->home_phome = $info_client['home_phome'];
            $client->work_phome = $info_client['work_phome'];
            $client->invoice_id = $invoice->id;
            $client->save();
            
            $info_services = $request->get('services');
            foreach ($info_services as $item) {
                $service = new InvoiceServices;
                $service->service_id = $item['service_id'];
                $service->name = $item['name'];
                $service->description = $item['description'];
                $service->price = $item['price'];
                $service->qty = $item['qty'];
                $service->total = $item['total'];
                $service->invoice_id = $invoice->id;
                $service->save();
            }
            $info_products = $request->get('products');
            foreach ($info_products as $item) {
                $product = new InvoiceProducts;
                $product->product_id = $item['product_id'];
                $product->name = $item['name'];
                $product->description = $item['description'];
                $product->price = $item['price'];
                $product->qty = $item['qty'];
                $product->total = $item['total'];
                $product->invoice_id = $invoice->id;
                $product->save();
                
                if($invoice->type == "invoice") {
                    $p = Product::find($item['product_id']);
                    if($p) {
                        $p->qty = $p->qty - $item['qty'];
                        $p->save();
                    }
                }
            }
            $info_payments = $request->get('payments');
            foreach ($info_payments as $item) {
                $payment = new InvoicePayments;
                $payment->payment_methods = $item['payment_methods'];
                $payment->paid = $item['paid'];
                $payment->number = $item['number'];
                $payment->invoice_id = $invoice->id;
                $payment->save();
            }
        }
        return;
    }
    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id){
        $this->validate($request, [
            "type" => 'required',
            //"number" => 'required',
            //"deposit" => 'required',
            "subtotal" => 'required',
            //"discount" => 'required',
            //"tax" => 'required',
            "total" => 'required',
        ]);
        $invoice = Invoice::find($id);
        if(Invoice::find($id)->update($request->all())){
            
            $client = Client::where("invoice_id",$id)->first();
            $info_client = $request->get('client');
            $client->name = $info_client['name'];
            $client->adress = $info_client['adress'];
            $client->city = $info_client['city'];
            $client->state = $info_client['state'];
            $client->zip = $info_client['zip'];
            $client->email = $info_client['email'];
            $client->cell_phome = $info_client['cell_phome'];
            $client->home_phome = $info_client['home_phome'];
            $client->work_phome = $info_client['work_phome'];
            $client->invoice_id = $id;
            $client->save();
            
            InvoiceServices::where("invoice_id",$id)->delete();
            $info_services = $request->get('services');
            foreach ($info_services as $item) {
                $service = new InvoiceServices;
                $service->service_id = $item['service_id'];
                $service->name = $item['name'];
                $service->description = $item['description'];
                $service->price = $item['price'];
                $service->qty = $item['qty'];
                $service->total = $item['total'];
                $service->invoice_id = $id;
                $service->save();
            }
            if($invoice->type == "invoice") {
                $temp = InvoiceProducts::where("invoice_id",$id)->get();
                foreach ($temp as $item) {
                    $p = Product::find($item['product_id']);
                    if($p) {
                        $p->qty = $p->qty + $item['qty'];
                        $p->save();
                    }
                }
            }
            InvoiceProducts::where("invoice_id",$id)->delete();
            $info_products = $request->get('products');
            foreach ($info_products as $item) {
                $product = new InvoiceProducts;
                $product->product_id = $item['product_id'];
                $product->name = $item['name'];
                $product->description = $item['description'];
                $product->price = $item['price'];
                $product->qty = $item['qty'];
                $product->total = $item['total'];
                $product->invoice_id = $id;
                $product->save();
                
                if($invoice->type == "invoice") {
                    $p = Product::find($item['product_id']);
                    if($p) {
                        $p->qty = $p->qty - $item['qty'];
                        $p->save();
                    }
                }
            }
            
            InvoicePayments::where("invoice_id",$id)->delete();
            $info_payments = $request->get('payments');
            foreach ($info_payments as $item) {
                $payment = new InvoicePayments;
                $payment->payment_methods = $item['payment_methods'];
                $payment->paid = $item['paid'];
                $payment->number = $item['number'];
                $payment->invoice_id = $id;
                $payment->save();
            }
        }
        return;
    }
    public function convert($id){
        $invoice = Invoice::findOrFail($id);
        $invoice_number = Setting::where("var","invoice_number")->firstOrFail();
        $t=time();
        $invoice->number = $invoice_number->value;
        $invoice->type = "invoice";
        $invoice->status = "UnPaid";
        $invoice->created_at = date("Y-m-d",$t);
        if($invoice->save()) {
            $invoice_number->value = $invoice_number->value + 1;
            $invoice_number->save();
            if($invoice->type == "invoice") {
                $temp = InvoiceProducts::where("invoice_id",$invoice->id)->get();
                foreach ($temp as $item) {
                    $p = Product::find($item['product_id']);
                    if($p) {
                        $p->qty = $p->qty - $item['qty'];
                        $p->save();
                    }
                }
            }
        }
        return;
    }
    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id){
        $invoice = Invoice::findOrFail($id);
        if($invoice) {
            Client::where("invoice_id",$id)->delete();
            InvoiceServices::where("invoice_id",$id)->delete();
            if($invoice->type == "invoice") {
                $temp = InvoiceProducts::where("invoice_id",$id)->get();
                foreach ($temp as $item) {
                    $p = Product::find($item['product_id']);
                    if($p) {
                        $p->qty = $p->qty + $item['qty'];
                        $p->save();
                    }
                }
            }
            
            InvoiceProducts::where("invoice_id",$id)->delete();
            InvoicePayments::where("invoice_id",$id)->delete();
        }
        $invoice->delete();
        return;
    }
    public function getClient($id) {
        $client = Client::where("invoice_id", $id)->firstOrFail();
        return $client;
    }
    public function getServices($id) {
        $services = InvoiceServices::where("invoice_id", $id)->get();
        return $services;
    }
    public function getProducts($id) {
        $products = InvoiceProducts::where("invoice_id", $id)->get();
        return $products;
    }
    public function getPayments($id) {
        $payments = InvoicePayments::where("invoice_id", $id)->get();
        return $payments;
    }
    public function stadistic(Request $request) {
        return [
            "stadistic" => [
                "invoice_qty" => Invoice::where("type",$request->get('type'))->count(),
                "general_balance" => Invoice::where("type", $request->get('type'))->sum("total"),
                "total_paid" => InvoicePayments::sum("paid"),
            ],
        ];
    }
    public function stadistict(Request $request) {
        $sum = 0;
        $invoices = Invoice::where(["type" => $request->get('type'), "h" => 0])->get();
        foreach ($invoices as $invoice) {
            $sum += InvoicePayments::where("invoice_id", $invoice->id)->sum("paid");
        }
        return [
            "stadistic" => [
                "invoice_qty" => Invoice::where(["type" => $request->get('type'), "h" => 0])->count(),
                "general_balance" => Invoice::where(["type" => $request->get('type'), "h" => 0])->sum("total"),
                "total_paid" => $sum,
            ],
        ];
    }
}
