@extends('layouts.pdf')
@section('content')
<div class="invoice" style="padding: 10px 20px; width: 100%;width: 100%;">
    <div class="row">
        <div class="col-md-12">
            <div class="page-header">
                <table style="width: 100%; margin: 0; padding: 0">
                    <tr style="margin: 0; padding: 0">
                        <td style="width: 80%; margin: 0; padding: 0"><h4><?php echo $worker->name?></h4></td>
                        <td style="width: 20%; margin: 0; padding: 0"><h5><?php echo date('M j, Y')?></h5></td>
                    </tr>
                </table>
            </div>
        </div>
        <div class="col-md-12">
            <div class="page-header" style="margin-top: 0">
                <h4>Hours Reports</h4>
            </div>
            <table class="table table-bordered table-striped table-condensed flip-content">
                <thead class="flip-content">
                <tr>
                    <th>Date</th>
                    <th>Hours</th>
                    <th>Price</th>
                    <th>Total</th>
                </tr>
                </thead>
                <?php $total = 0?>
                <tbody>
                <?php foreach ($work_reports as $report) :?>
                <?php $total += $report->total?>
                <?php if ($report->type == 'hours') :?>
                <tr>
                    <td><?php echo $report->date?></td>
                    <td><?php echo $report->hours?></td>
                    <td>$<?php echo number_format($report->price, 2)?></td>
                    <td>$<?php echo number_format(round($report->total, 2), 2)?></td>
                </tr>
                <?php endif;?>
                <?php endforeach;?>
                </tbody>
            </table>
        </div>
        <?php if ($worker->ocupation == 'CARPINTERO' || $worker->ocupation == 'GRANITERO') :?>
        <div class="col-md-12">
            <div class="page-header" style="margin-top: 20px">
                <h4>Adjustment Reports</h4>
            </div>
            <table class="table table-bordered table-striped table-condensed flip-content">
                <thead class="flip-content">
                <tr>
                    <th>Date</th>
                    <?php if ($worker->ocupation == 'CARPINTERO') :?>
                    <th>Gabinet(in)</th>
                    <?php endif?>
                    <th>Tapa(in)</th>
                    <?php if ($worker->ocupation == 'CARPINTERO') :?>
                    <th>Closet(feet)</th>
                    <?php endif?>
                    <?php if ($worker->ocupation == 'CARPINTERO') :?>
                    <th>Door(feet)</th>
                    <?php endif?>
                    <th>Total</th>
                </tr>
                </thead>
                <tbody>
                <?php foreach ($work_reports as $report) :?>
                <?php if ($report->type == 'adjust') :?>
                <tr>
                    <td><?php echo $report->date?></td>
                    <?php if ($worker->ocupation == 'CARPINTERO') :?>
                    <td><?php echo $report->gabinet?> in <?php if ($report->gabinet > 0) :?>[$<?php echo number_format($report->gabinet_price, 2)?>]<?php endif?></td>
                    <?php endif?>
                    <td><?php echo $report->cover?> in <?php if ($report->cover > 0) :?>[$<?php echo number_format($report->cover_price, 2)?>]<?php endif?></td>
                    <?php if ($worker->ocupation == 'CARPINTERO') :?>
                    <td><?php echo $report->closet?> feet <?php if ($report->closet > 0) :?>[$<?php echo number_format($report->closet_price, 2)?>]<?php endif?></td>
                    <?php endif?>
                    <?php if ($worker->ocupation == 'CARPINTERO') :?>
                    <td><?php echo $report->door?> feet <?php if ($report->door > 0) :?>[$<?php echo number_format($report->door_price, 2)?>]<?php endif?></td>
                    <?php endif?>
                    <td>$<?php echo number_format(round($report->total, 2), 2)?></td>
                </tr>
                <?php endif;?>
                <?php endforeach;?>
                </tbody>
            </table>
        </div>
        <?php endif?>
    </div>
    <div class="row">
        <div class="col-md-4 col-md-offset-8">
            <br/><br/>
            <table class="table table-bordered table-striped">
                <thead>
                <tr>
                    <th>Salary</th>
                </tr>
                </thead>
                <tbody>
                <tr>
                    <td>$<?php echo number_format(round($total, 2), 2)?></td>
                </tr>
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection
