@extends('layouts.theme')
@section('breadcrumb')
    <ul class="page-breadcrumb">
        <li>
            <i class="fa fa-home"></i>
            <a href="/">Home</a>
            <i class="fa fa-angle-right"></i>
        </li>
        <li>Provider Bills</li>
    </ul>
@endsection
@section('content')
<div id="provider-bills">

<div class="portlet light">
    <div class="portlet-title">
            <div class="caption">
                    <i class="icon-puzzle font-grey-gallery"></i>
                    <span class="caption-subject bold font-grey-gallery uppercase">
                    Provider Bills </span>
                    <span class="caption-helper">List of Provider Bills...</span>
            </div>
            <div class="tools">
                    <a href="" class="collapse" data-original-title="" title="">
                    </a>
                    <a href="#" class="reload_own" v-on:click.prevent="getBills()">
                    </a>
            </div>
    </div>
    <div class="portlet-body flip-scroll">
        <div class="row">
            <div class="col-md-12">
                <div class="table-toolbar">
                    <div class="btn-group">
                        <button id="sample_editable_1_new" class="btn green" v-on:click.prevent="showForm()">
                        Add New Bills <i class="fa fa-plus"></i>
                        </button>
                    </div>
                </div>
                <pagination :pagination="pagination" :offset="3" @change="changePage"></pagination>
                <table_provider_bills :loading="loading" :data="bills" @edit="editBill" @delete="deleteBill"></table_provider_bills>
                <loading :loading="loading"></loading>
                <pagination :pagination="pagination" :offset="3" @change="changePage"></pagination>
            </div>
        </div>
    </div>
</div>	
@include('bills.create')
</div>
@endsection


@section('scripts')
<script src="{{ asset('js/provider_bills.js') }}"></script>
@endsection