var photo_counter = 0;
Dropzone.options.realDropzone = {

    uploadMultiple: false,
    parallelUploads: 100,
    maxFilesize: 8,
    previewsContainer: '#dropzonePreview',
    previewTemplate: document.querySelector('#preview-template').innerHTML,
    addRemoveLinks: true,
    dictRemoveFile: 'Remove Image',
    dictFileTooBig: 'Image is bigger than 8MB',
    thumbnailWidth:"250",
    thumbnailHeight:"250",

    // The setting up of the dropzone
    init:function() {
        var thisDropzone = this;
        thisDropzone.on("addedfile", function(file) {
          file.previewElement.addEventListener("click", function() {
            var resource = jQuery("#resource").val();
            var resource_id = jQuery("#resource_id").val();
            if(file.name.indexOf(resource) >= 0)
                window.open("/images/"+file.name); 
            else window.open("/images/"+resource+'-'+resource_id+"-"+file.name); 
          });
        });
        $.getJSON("/upload/images/all", {
            resource: jQuery("#resource").val(),
            resource_id: jQuery("#resource_id").val(),
        }).done(function (data) {
            if (data.Data != '') {
                $.each(data.Data, function (index, item) {
                        //// Create the mock file:
                        var mockFile = {
                            name: item.AttachmentID,
                            size: 100,
                        };

                        // Call the default addedfile event handler
                        thisDropzone.emit("addedfile", mockFile);

                        // And optionally show the thumbnail of the file:
                        thisDropzone.emit("thumbnail", mockFile, item.Path);
                        
                        thisDropzone.createThumbnailFromUrl(mockFile, '/images/' + item.AttachmentID);
                        
                        thisDropzone.emit("complete", mockFile);

                        // If you use the maxFiles option, make sure you adjust it to the
                        // correct amount:
                        //var existingFileCount = 1; // The number of files already uploaded
                        //myDropzone.options.maxFiles = myDropzone.options.maxFiles - existingFileCount;
                        photo_counter = photo_counter + 1;
                });
                $("#photoCounter").text( "(" + photo_counter + ")");
            }
        });
        this.on("removedfile", function(file) {
            $.ajax({
                type: 'POST',
                url: 'images/delete',
                data: {
                    id: file.name,
                    resource: jQuery("#resource").val(),
                    resource_id: jQuery("#resource_id").val(),
                },
                dataType: 'html',
                success: function(data){
                    var rep = JSON.parse(data);
                    if(rep.code == 200)
                    {
                        photo_counter--;
                        $("#photoCounter").text( "(" + photo_counter + ")");
                    }

                }
            });

        } );
    },
    error: function(file, response) {
        if($.type(response) === "string")
            var message = response; //dropzone sends it's own error messages in string
        else
            var message = response.message;
        file.previewElement.classList.add("dz-error");
        _ref = file.previewElement.querySelectorAll("[data-dz-errormessage]");
        _results = [];
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
            node = _ref[_i];
            _results.push(node.textContent = message);
        }
        return _results;
    },
    success: function(file,done) {
        photo_counter++;
        $("#photoCounter").text( "(" + photo_counter + ")");
    }
    
}