<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePaymentMethodsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('payment_methods', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->string('name');
            $table->string('description');
            $table->boolean('available');
            $table->timestamps();
        });
        DB::table('payment_methods')->insert(
            array(
                'name' => 'cash',
                'description' => 'cash',
                'available' => true,
            )
        );
        DB::table('payment_methods')->insert(
            array(
                'name' => 'check',
                'description' => 'check',
                'available' => true,
            )
        );
        DB::table('payment_methods')->insert(
            array(
                'name' => 'debit',
                'description' => 'debit',
                'available' => true,
            )
        );
        DB::table('payment_methods')->insert(
            array(
                'name' => 'cedit',
                'description' => 'cedit',
                'available' => true,
            )
        );
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('payment_methods');
    }
}
