<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class ProviderBills extends Model
{
    protected $fillable = ['provider_id', "invoice_number", "description","date", 'payment_methods_id', 'sub_total', 'tax', 'total', "status"];
    
    public function provider()
    {
        return $this->belongsTo(Provider::class);
    }
    public function payment_methods()
    {
        return $this->belongsTo(PaymentMethod::class);
    }
    public function provider_bills_Lines()
    {
        return $this->hasMany(ProviderBillsLine::class);
    }
}
