<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;

class Invoice extends Mailable
{
    use Queueable, SerializesModels;
    public $pdf;
    public $images;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->images = [];
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        foreach ($this->images as $image) {
            if($image['select'])
                $this->attach(public_path('images/').$image['AttachmentID']);
        }
        return $this->from(env('MAIL_USERNAME', 'ctrlbook@designsrr.com'))
                ->view('mail.invoice')
                ->CC('andypeace09@gmail.com')
                ->subject('Invoice Detail / SHIPPING CONFIRMED')
                ->attach(public_path('pdf/').$this->pdf);
    }
}
