<?php

namespace App\Http\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\WorkReports;
use App\Worker;
use Illuminate\Support\Facades\DB;

class WorkReportsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if(!empty($request->get("search"))) {
            $data = WorkReports::with("worker")
                    ->join('workers', 'work_reports.worker_id', '=', 'workers.id')
                    ->where("workers.name", "like", "%".$request->get("search")."%")
                    ->orWhere("work_reports.hours", "like", "%".$request->get("search")."%")
                    ->orWhere("work_reports.total", "like", "%".$request->get("search")."%")
                    ->orWhere("work_reports.status", "like", "%".$request->get("search")."%")
                    ->orWhere(DB::raw("DATE_FORMAT(work_reports.created_at, '%d %M %Y')"), "like", "%".$request->get("search")."%")
                    ->orWhere(DB::raw("DATE_FORMAT(work_reports.date, '%d %M %Y')"), "like", "%".$request->get("search")."%")
                    ->orWhere(DB::raw("DATE_FORMAT(work_reports.date_paid, '%d %M %Y')"), "like", "%".$request->get("search")."%")
                    ->select("work_reports.*")
                    ->orderBy('work_reports.id','DESC')->paginate(25);
        }
        else {
            $data = WorkReports::with("worker")->orderBy('id','DESC')->paginate(25);
        }
        return [
            'pagination' => [
                'total'         => $data->total(),
                'current_page'  => $data->currentPage(),
                'per_page'      => $data->perPage(),
                'last_page'     => $data->lastPage(),
                'from'          => $data->firstItem(),
                'to'            => $data->lastItem(),
            ],
            "work_reports" => $data
        ];
    }

    public function search(){
        $work_reports = WorkReports::with("worker")->get();
        return $work_reports;
    }

    public function payrol(Request $request){
        $work_reports = WorkReports::where(["worker_id" => $request->get("id"), "status" => "UnPaid"])->get();
        return $work_reports;
    }

    public function pay(Request $request){
        $work_reports = WorkReports::where(["worker_id" => $request->get("id"), "status" => "UnPaid"])->get();
        foreach ($work_reports as $item) {
            $item->status = "Paid";
            $item->date_paid = date("Y-m-d");
            $item->save();
        }
        return;
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            "worker_id" => 'required',
            //"date" => 'required',
            //"date" => 'required|unique:work_reports,date,NULL,id,worker_id,',
            //"date" => 'required|unique_with:work_reports,worker_id,type',
            "date" => 'required',
            "price" => 'required',
            "total" => 'required',
            "status" => 'required'
        ]);
        WorkReports::create($request->all());
        return;
    }

    public function getPayment(Request $request){
        $report = WorkReports::where(['status' => "Paid", "worker_id" => $request->get("worker_id")])->get();
        return $report;
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            "worker_id" => 'required',
            //"date" => 'required',
            "date" => 'required',
            "price" => 'required',
            "total" => 'required',
        ]);
        WorkReports::find($id)->update($request->all());
        return;
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $data = WorkReports::findOrFail($id);
        $data->delete();
    }
}
