<?php

namespace App\Http\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Product;

class ProductsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request){
        if(!empty($request->get("search"))) {
            $data = Product::with("provider")
                    ->join('providers', 'products.provider_id', '=', 'providers.id')
                    ->where("products.name", "like", "%".$request->get("search")."%")
                    ->orWhere("providers.name", "like", "%".$request->get("search")."%")
                    ->orWhere("products.description", "like", "%".$request->get("search")."%")
                    ->orWhere("products.qty", "like", "%".$request->get("search")."%")
                    ->orWhere("products.extent", "like", "%".$request->get("search")."%")
                    ->orWhere("products.price", "like", "%".$request->get("search")."%")
                    ->orderBy('products.id','DESC')
                    ->select("products.*")
                    ->paginate(25);
        }
        else {
            $data = Product::with("provider")->orderBy('id','DESC')->paginate(25);
        }
        return [
            'pagination' => [
                'total'         => $data->total(),
                'current_page'  => $data->currentPage(),
                'per_page'      => $data->perPage(),
                'last_page'     => $data->lastPage(),
                'from'          => $data->firstItem(),
                'to'            => $data->lastItem(),
            ],
            "products" => $data
        ];
    }
    public function getAll(){
        $products = Product::with("provider")->where(['advailable' => 1, ["qty", ">", 0]])->get();
        return $products;
    }
    public function search(){
        $products = Product::with("provider")->get();
        return $products;
    }
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request){
        $this->validate($request, [
            "name" => 'required',
            "description" => 'required',
            "extent" => 'required',
            "price" => 'required',
            "qty" => 'required',
            "advailable" => 'required',
            "provider_id" => 'required',
        ]);
        $product = Product::create($request->all());
        return $product;
    }
    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id){
        $this->validate($request, [
            "name" => 'required',
            "description" => 'required',
            "extent" => 'required',
            "price" => 'required',
            "qty" => 'required',
            "advailable" => 'required',
            "provider_id" => 'required',
        ]);
        Product::find($id)->update($request->all());
        return;
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id){
        $data = Product::findOrFail($id);
        $data->delete();
    }
}
