<?php

namespace App\Http\Controllers\Api;

use App\Email;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Log;
use App\Invoice;
use App\Setting;
use App\Client;
use App\ClientO;
use App\InvoiceServices;
use App\InvoiceProducts;
use App\InvoicePayments;
use App\Product;
use App\Email as EmailSend;
use Illuminate\Support\Facades\DB;

class InvoicesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request){
        $showSubInvoices = $request->get("showSubInvoices");
        if(!empty($request->get("search"))) {
            if($showSubInvoices == "false") {
                $invoices = Invoice::with("client","payments")
                        ->join('clients', 'clients.invoice_id', '=', 'invoices.id')
                        ->where("invoices.type", "invoice")
                        ->where("invoices.del", "!=", 1)
                        ->where("invoices.related_invoice", null)
                        ->where(function($query) use($request){
                            $query->where("invoices.number", "like", "%".$request->get("search")."%")
                                    ->orWhere("clients.name", "like", "%".$request->get("search")."%")
                                    ->orWhere(DB::raw("DATE_FORMAT(invoices.created_at, '%d %M %Y')"), "like", "%".$request->get("search")."%")
                                    ->orWhere("invoices.total", "like", "%".$request->get("search")."%")
                                    ->orWhere("invoices.related_invoice", "like", "%".$request->get("search")."%")
                                    ->orWhere("invoices.status", "like", "%".$request->get("search")."%");
                        })
                        ->orderBy('invoices.number','DESC')
                        ->select([
                            "invoices.*",
                            DB::raw("'0' as loading"),
                            DB::raw("'0' as loading_signed_pdf"),
                            ])
                        ->paginate(25);
            }
            else {
                $invoices = Invoice::with("client","payments")
                        ->join('clients', 'clients.invoice_id', '=', 'invoices.id')
                        ->where("invoices.type", "invoice")
                        ->where("invoices.del", "!=", 1)
                        ->where(function($query) use($request){
                            $query->where("invoices.number", "like", "%".$request->get("search")."%")
                                    ->orWhere("clients.name", "like", "%".$request->get("search")."%")
                                    ->orWhere(DB::raw("DATE_FORMAT(invoices.created_at, '%d %M %Y')"), "like", "%".$request->get("search")."%")
                                    ->orWhere("invoices.total", "like", "%".$request->get("search")."%")
                                    ->orWhere("invoices.related_invoice", "like", "%".$request->get("search")."%")
                                    ->orWhere("invoices.status", "like", "%".$request->get("search")."%");
                        })
                        ->orderBy('invoices.number','DESC')
                        ->select([
                            "invoices.*",
                            DB::raw("'0' as loading"),
                            DB::raw("'0' as loading_signed_pdf"),
                        ])
                        ->paginate(25);
            }
        }
        else {
            if($showSubInvoices == "false") {
                $invoices = Invoice::with("client","payments")
                        ->where("type", "invoice")
                        ->where("invoices.del", "!=", 1)
                        ->where("invoices.related_invoice", null)
                        ->orderBy('invoices.number','DESC')
                        ->select([
                            "invoices.*",
                            DB::raw("'0' as loading"),
                            DB::raw("'0' as loading_signed_pdf"),
                            ])
                        ->paginate(25);
            }
            else {
                $invoices = Invoice::with("client","payments")
                        ->where("type", "invoice")
                        ->where("invoices.del", "!=", 1)
                        ->orderBy('invoices.number','DESC')
                        ->select([
                            "invoices.*",
                            DB::raw("'0' as loading"),
                            DB::raw("'0' as loading_signed_pdf"),
                            ])
                        ->paginate(25);
            }
        }
        return [
            'pagination' => [
                'total'         => $invoices->total(),
                'current_page'  => $invoices->currentPage(),
                'per_page'      => $invoices->perPage(),
                'last_page'     => $invoices->lastPage(),
                'from'          => $invoices->firstItem(),
                'to'            => $invoices->lastItem(),
            ],
            "invoices" => $invoices,
        ];
    }
    public function getAll(){
        $invoices = Invoice::where(["type" => "invoice"])
                ->where("invoices.del", "!=", 1)
                ->select(["invoices.number as id", DB::raw("concat(invoices.number, ' - (',clients.name, ' - $' ,  invoices.total, ')') as name")])
                ->join('clients', 'invoices.id', '=', 'clients.invoice_id')
                ->get();
        return $invoices;
    }
    public function search(){
        $invoices = Invoice::with("client","payments")
                ->where(["type" => "invoice"])
                ->where("invoices.del", "!=", 1)
                ->orderBy('number','DESC')
                ->get();
        return $invoices;
    }
    public function searchEstimates(){
        $invoices = Invoice::with("client")
                ->where(["type" => "estimate"])
                ->where("invoices.del", "!=", 1)
                ->orderBy('id','DESC')
                ->get();
        return $invoices;
    }
    public function invoicest(Request $request){
        if(!empty($request->get("search"))) {
            $invoices = Invoice::with("client", "payments")
                    ->join('clients', 'clients.invoice_id', '=', 'invoices.id')
                    ->where(["type" => "invoice", "h" => "0"])
                    ->where("invoices.del", "!=", 1)
                    ->where(function($query) use($request){
                        $query->where("clients.name", "like", "%".$request->get("search")."%")
                                ->orWhere(DB::raw("DATE_FORMAT(invoices.created_at, '%d %M %Y')"), "like", "%".$request->get("search")."%")
                                ->orWhere("invoices.total", "like", "%".$request->get("search")."%")
                                ->orWhere("invoices.status", "like", "%".$request->get("search")."%");
                    })
                    ->orderBy('invoices.number','DESC')
                        ->select([
                            "invoices.*",
                            DB::raw("'0' as loading"),
                            DB::raw("'0' as loading_signed_pdf"),
                            ])
                    ->paginate(25);
        }
        else {
            $invoices = Invoice::with("client", "payments")
                    ->where(["type" => "invoice", "h" => "0"])
                    ->where("invoices.del", "!=", 1)
                    ->orderBy('invoices.number','DESC')
                        ->select([
                            "invoices.*",
                            DB::raw("'0' as loading"),
                            DB::raw("'0' as loading_signed_pdf"),
                            ])
                    ->paginate(25);
        }
        return [
            'pagination' => [
                'total'         => $invoices->total(),
                'current_page'  => $invoices->currentPage(),
                'per_page'      => $invoices->perPage(),
                'last_page'     => $invoices->lastPage(),
                'from'          => $invoices->firstItem(),
                'to'            => $invoices->lastItem(),
            ],
            "invoices" => $invoices,
        ];
    }
    public function estimates(Request $request){
        if(!empty($request->get("search"))) {
            $invoices = Invoice::with("client")
                    ->join('clients', 'clients.invoice_id', '=', 'invoices.id')
                    ->where("type", "estimate")
                    ->where("invoices.del", "!=", 1)
                    ->where(function($query) use($request){
                        $query->Where("clients.name", "like", "%".$request->get("search")."%")
                                ->orWhere(DB::raw("DATE_FORMAT(invoices.created_at, '%d %M %Y')"), "like", "%".$request->get("search")."%")
                                ->orWhere("invoices.total", "like", "%".$request->get("search")."%");
                    })
                    ->orderBy('invoices.id','DESC')
                    ->select([
                        "invoices.*",
                        DB::raw("'0' as loading"),
                        DB::raw("'0' as loading_signed_pdf"),
                        ])
                    ->paginate(25);
        }
        else {
            $invoices = Invoice::with("client")
                    ->where("type", "estimate")
                    ->where("invoices.del", "!=", 1)
                    ->orderBy('id','DESC')
                    ->select([
                        "invoices.*",
                        DB::raw("'0' as loading"),
                        DB::raw("'0' as loading_signed_pdf"),
                        ])
                    ->paginate(10);
        }
        return [
            'pagination' => [
                'total'         => $invoices->total(),
                'current_page'  => $invoices->currentPage(),
                'per_page'      => $invoices->perPage(),
                'last_page'     => $invoices->lastPage(),
                'from'          => $invoices->firstItem(),
                'to'            => $invoices->lastItem(),
            ],
            "invoices" => $invoices,
        ];
    }
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request){
        $this->validate($request, [
            "type" => 'required',
            //"number" => 'required',
            //"deposit" => 'required',
            "subtotal" => 'required',
            //"discount" => 'required',
            //"tax" => 'required',
            "total" => 'required',
        ]);
        $invoice_number = Setting::where("var","invoice_number")->firstOrFail();
        if($invoice = Invoice::create($request->all())) {
            if($invoice->type == "invoice") {
                $invoice->number = $invoice_number->value;
                if($invoice->save()) {
                    $invoice_number->value = $invoice_number->value + 1;
                    $invoice_number->save();
                }
            }
            $info_client = $request->get('client');
            
            $client_id = null;
            if(isset($info_client['client_id'])) $client_id = $info_client['client_id'];
            
            if(empty($client_id)) {
                $client_o = new ClientO;
                $client_o->name = $info_client['name'];
                $client_o->adress = $info_client['adress'];
                $client_o->city = $info_client['city'];
                $client_o->state = $info_client['state'];
                $client_o->zip = $info_client['zip'];
                $client_o->email = $info_client['email'];
                $client_o->cell_phome = $info_client['cell_phome'];
                $client_o->home_phome = $info_client['home_phome'];
                $client_o->work_phome = $info_client['work_phome'];
                $client_o->save();
                $client_id = $client_o->id; 
            }
            
            $client = new Client;
            $client->name = $info_client['name'];
            $client->adress = $info_client['adress'];
            $client->city = $info_client['city'];
            $client->state = $info_client['state'];
            $client->zip = $info_client['zip'];
            $client->email = $info_client['email'];
            $client->cell_phome = $info_client['cell_phome'];
            $client->home_phome = $info_client['home_phome'];
            $client->work_phome = $info_client['work_phome'];
            $client->client_id = $client_id;
            $client->invoice_id = $invoice->id;
            $client->save();
            
            $info_services = $request->get('services');
            foreach ($info_services as $item) {
                $service = new InvoiceServices;
                $service->service_id = $item['service_id'];
                $service->name = $item['name'];
                $service->description = $item['description'];
                $service->price = $item['price'];
                $service->qty = $item['qty'];
                $service->total = $item['total'];
                $service->invoice_id = $invoice->id;
                $service->save();
            }
            $info_products = $request->get('products');
            foreach ($info_products as $item) {
                $product = new InvoiceProducts;
                $product->product_id = $item['product_id'];
                $product->name = $item['name'];
                $product->description = $item['description'];
                $product->price = $item['price'];
                $product->qty = $item['qty'];
                $product->total = $item['total'];
                $product->invoice_id = $invoice->id;
                $product->save();
                
                if($invoice->type == "invoice") {
                    $p = Product::find($item['product_id']);
                    if($p) {
                        $p->qty = $p->qty - $item['qty'];
                        $p->save();
                    }
                }
            }
            $info_payments = $request->get('payments');
            $flag_cash = false;
            $flag_other = true;
            foreach ($info_payments as $item) {
                $payment = new InvoicePayments;
                $payment->payment_methods = $item['payment_methods'];
                $payment->paid = $item['paid'];
                $payment->number = $item['number'];
                $payment->invoice_id = $invoice->id;
                $payment->save();
                if($item['payment_methods'] == "cash") $flag_cash = true;
                if($item['payment_methods'] != "cash") $flag_other = true;
            }
            if($flag_cash) {
                $invoice->h = 1;
                $invoice->save();
            }
            else {
                $invoice->h = 0;
                $invoice->save();
            }
            if($invoice->status == "Paid" && $flag_cash && $flag_other) $this->copy($invoice, $client_id,  $info_client, $info_payments);
            else if(!$flag_cash) $this->deleteR ($invoice);
        }
        return;
    }
    private function copy($invoicec, $client_id, $info_client, $info_payments) {
        
        $is = Invoice::where("related_invoice", $invoicec->number)->get();
        if(count($is) == 0) {
            //$invoice_number = Setting::where("var","invoice_number")->firstOrFail();
            $invoice = new Invoice;
            $invoice->type = $invoicec->type;
            $invoice->number = $invoicec->number.".1";
            $invoice->deposit = $invoicec->deposit;
            $invoice->subtotal = $invoicec->subtotal;
            $invoice->discount = 0;
            $invoice->tax = $invoicec->tax;
            $invoice->total = $invoicec->total;
            $invoice->status = $invoicec->status;
            $invoice->related_invoice = $invoicec->number;
            $invoice->save();
            /*if($invoice->save()) {

                $invoice_number->value = $invoice_number->value + 1;
                $invoice_number->save();
            }*/
        }
        else {
            $invoice = $is[0];
        }
        Client::where("invoice_id",$invoice->id)->delete();
        $client = new Client;
        $client->name = $info_client['name'];
        $client->adress = $info_client['adress'];
        $client->city = $info_client['city'];
        $client->state = $info_client['state'];
        $client->zip = $info_client['zip'];
        $client->email = $info_client['email'];
        $client->cell_phome = $info_client['cell_phome'];
        $client->home_phome = $info_client['home_phome'];
        $client->work_phome = $info_client['work_phome'];
        $client->client_id = $client_id;
        $client->invoice_id = $invoice->id;
        $client->save();

        $suma_no_cash = 0;
        InvoicePayments::where("invoice_id",$invoice->id)->delete();
        foreach ($info_payments as $item) {
            if($item['payment_methods'] != "cash") {
                $payment = new InvoicePayments;
                $payment->payment_methods = $item['payment_methods'];
                $payment->paid = $item['paid'];
                $payment->number = $item['number'];
                $payment->invoice_id = $invoice->id;
                $payment->save();
                $suma_no_cash += $item['paid'];
            }
        }
        InvoiceServices::where("invoice_id",$invoice->id)->delete();
        $service = new InvoiceServices;
        $service->service_id = 1;
        $service->name = "Fabrication";
        $service->description = "Fabricacion e instalacion de gabinetes de cosina Incluye: los tiradores de barrita.";
        $service->price = $suma_no_cash / 1.07;
        $service->qty = 1;
        $service->total = $suma_no_cash / 1.07;
        $service->invoice_id = $invoice->id;
        $service->save();

        $invoice->subtotal = $suma_no_cash / 1.07;
        $invoice->tax = $suma_no_cash - ($suma_no_cash / 1.07);
        $invoice->total = $suma_no_cash;
        $invoice->save();
    }
    private function deleteR($invoicec) {
        $invoice = Invoice::where("related_invoice",$invoicec->number)->first();
        if($invoice) $this->destroy($invoice->id);
    }
    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id){
        $this->validate($request, [
            "type" => 'required',
            //"number" => 'required',
            //"deposit" => 'required',
            "subtotal" => 'required',
            //"discount" => 'required',
            //"tax" => 'required',
            "total" => 'required',
        ]);
        //$invoice = Invoice::find($id);
        if(Invoice::find($id)->update($request->all())){
            $invoice = Invoice::find($id);
            
            /*if(file_exists(public_path('pdf/').$invoice->pdf)) @unlink(public_path('pdf/').$invoice->pdf);
            if(file_exists(public_path('pdf/').$invoice->pdf_signed)) @unlink(public_path('pdf/').$invoice->pdf_signed);*/
            $invoice->pdf = "";
            $invoice->pdf_signed = "";
            
            $client = Client::where("invoice_id",$id)->first();
            $info_client = $request->get('client');
            
            $client_id = null;
            if(isset($info_client['client_id'])) $client_id = $info_client['client_id'];
            
            if(empty($client_id)) {
                $client_o = new ClientO;
                $client_o->name = $info_client['name'];
                $client_o->adress = $info_client['adress'];
                $client_o->city = $info_client['city'];
                $client_o->state = $info_client['state'];
                $client_o->zip = $info_client['zip'];
                $client_o->email = $info_client['email'];
                $client_o->cell_phome = $info_client['cell_phome'];
                $client_o->home_phome = $info_client['home_phome'];
                $client_o->work_phome = $info_client['work_phome'];
                $client_o->save();
                $client_id = $client_o->id; 
            }
            
            $client->name = $info_client['name'];
            $client->adress = $info_client['adress'];
            $client->city = $info_client['city'];
            $client->state = $info_client['state'];
            $client->zip = $info_client['zip'];
            $client->email = $info_client['email'];
            $client->cell_phome = $info_client['cell_phome'];
            $client->home_phome = $info_client['home_phome'];
            $client->work_phome = $info_client['work_phome'];
            $client->client_id = $client_id;
            $client->invoice_id = $id;
            $client->save();
            
            InvoiceServices::where("invoice_id",$id)->delete();
            $info_services = $request->get('services');
            foreach ($info_services as $item) {
                $service = new InvoiceServices;
                $service->service_id = $item['service_id'];
                $service->name = $item['name'];
                $service->description = $item['description'];
                $service->price = $item['price'];
                $service->qty = $item['qty'];
                $service->total = $item['total'];
                $service->invoice_id = $id;
                $service->save();
            }
            if($invoice->type == "invoice") {
                $temp = InvoiceProducts::where("invoice_id",$id)->get();
                foreach ($temp as $item) {
                    $p = Product::find($item['product_id']);
                    if($p) {
                        $p->qty = $p->qty + $item['qty'];
                        $p->save();
                    }
                }
            }
            InvoiceProducts::where("invoice_id",$id)->delete();
            $info_products = $request->get('products');
            foreach ($info_products as $item) {
                $product = new InvoiceProducts;
                $product->product_id = $item['product_id'];
                $product->name = $item['name'];
                $product->description = $item['description'];
                $product->price = $item['price'];
                $product->qty = $item['qty'];
                $product->total = $item['total'];
                $product->invoice_id = $id;
                $product->save();
                
                if($invoice->type == "invoice") {
                    $p = Product::find($item['product_id']);
                    if($p) {
                        $p->qty = $p->qty - $item['qty'];
                        $p->save();
                    }
                }
            }
            
            InvoicePayments::where("invoice_id",$id)->delete();
            $info_payments = $request->get('payments');
            $flag_cash = false;
            $flag_other = false;
            foreach ($info_payments as $item) {
                $payment = new InvoicePayments;
                $payment->payment_methods = $item['payment_methods'];
                $payment->paid = $item['paid'];
                $payment->number = $item['number'];
                $payment->invoice_id = $id;
                $payment->save();
                if($item['payment_methods'] == "cash") $flag_cash = true;
                if($item['payment_methods'] != "cash") $flag_other = true;
            }
            if($flag_cash) {
                $invoice->h = 1;
                $invoice->save();
            }
            else {
                $invoice->h = 0;
                $invoice->save();
            }
            if($invoice->status == "Paid" && $flag_cash && $flag_other) {
                $this->copy($invoice, $client_id,  $info_client, $info_payments);
            }
            else if(!$flag_cash) $this->deleteR($invoice);
        }
        return;
    }
    public function convert($id){
        $invoice = Invoice::findOrFail($id);
        $invoice_number = Setting::where("var","invoice_number")->firstOrFail();
        $t=time();
        $invoice->number = $invoice_number->value;
        $invoice->type = "invoice";
        $invoice->status = "UnPaid";
        $invoice->created_at = date("Y-m-d",$t);
        $invoice->pdf = "";
        $invoice->pdf_signed = "";
        if($invoice->save()) {
            $invoice_number->value = $invoice_number->value + 1;
            $invoice_number->save();
            if($invoice->type == "invoice") {
                $temp = InvoiceProducts::where("invoice_id",$invoice->id)->get();
                foreach ($temp as $item) {
                    $p = Product::find($item['product_id']);
                    if($p) {
                        $p->qty = $p->qty - $item['qty'];
                        $p->save();
                    }
                }
            }
        }
        return;
    }
    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id){
        //$invoice = Invoice::findOrFail($id);
        /*if($invoice) {
            Client::where("invoice_id",$id)->delete();
            InvoiceServices::where("invoice_id",$id)->delete();
            if($invoice->type == "invoice") {
                $temp = InvoiceProducts::where("invoice_id",$id)->get();
                foreach ($temp as $item) {
                    $p = Product::find($item['product_id']);
                    if($p) {
                        $p->qty = $p->qty + $item['qty'];
                        $p->save();
                    }
                }
            }
            
            InvoiceProducts::where("invoice_id",$id)->delete();
            InvoicePayments::where("invoice_id",$id)->delete();
        }
        $invoice->delete();*/
        //$invoice->del = 1;
        //$invoice->save();
        return;
    }
    public function getClient($id) {
        $client = Client::where("invoice_id", $id)->firstOrFail();
        return $client;
    }
    public function getServices($id) {
        $services = InvoiceServices::where("invoice_id", $id)->get();
        return $services;
    }
    public function getProducts($id) {
        $products = InvoiceProducts::where("invoice_id", $id)->get();
        return $products;
    }
    public function getPayments($id) {
        $payments = InvoicePayments::where("invoice_id", $id)->get();
        return $payments;
    }
    public function stadistic(Request $request) {
        $sum = 0;
        $invoices = Invoice::where(["type" => $request->get('type'), "related_invoice" => null])
                ->where("invoices.del", "!=", 1)
                ->get();
        foreach ($invoices as $invoice) {
            $sum += InvoicePayments::where("invoice_id", $invoice->id)->sum("paid");
        }
        return [
            "stadistic" => [
                "invoice_qty" => Invoice::where("type",$request->get('type'))->where("invoices.del", "!=", 1)->where("related_invoice", null)->count(),
                "general_balance" => Invoice::where("type", $request->get('type'))->where("invoices.del", "!=", 1)->where("related_invoice", null)->sum("total"),
                "total_paid" => $sum,
            ],
        ];
    }
    public function stadistict(Request $request) {
        $sum = 0;
        $invoices = Invoice::where(["type" => $request->get('type'), "h" => 0])
                ->where("invoices.del", "!=", 1)
                ->get();
        foreach ($invoices as $invoice) {
            $sum += InvoicePayments::where("invoice_id", $invoice->id)->sum("paid");
        }
        return [
            "stadistic" => [
                "invoice_qty" => Invoice::where(["type" => $request->get('type'), "h" => 0])->where("invoices.del", "!=", 1)->count(),
                "general_balance" => Invoice::where(["type" => $request->get('type'), "h" => 0])->where("invoices.del", "!=", 1)->sum("total"),
                "total_paid" => $sum,
            ],
        ];
    }
    public function send(Request $request){
        try{
            $invoice = new \App\Mail\Invoice();
            
            $item = $request->get('item');
            $pdf = $request->get('pdf');
            $pdf_signed = $request->get('pdf_signed');
            
            if(!empty($pdf_signed)) $invoice->pdf = $pdf_signed;
            else $invoice->pdf = $pdf;
            
            $invoice->images = $request->get('images');
            
            Mail::to($request->get('email'))->send($invoice);
            $email = new EmailSend;
            $email->invoice = $request->get('invoice');
            $email->name = $request->get('name');
            $email->to = $request->get('email');
            $email->pdf =  $invoice->pdf;
            $email->images = json_encode($request->get('images'));
            $email->save();
        }
        catch(Exception $ex){
            Log::warning('Showing send email error for user: ' . $request->get('email'));
        }
    }
}
