<?php

namespace App\Http\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\ClientO;

class ClientsOController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if(!empty($request->get("search"))) {
            $data = ClientO::where("name", "like", "%".$request->get("search")."%")
                    ->orWhere("adress", "like", "%".$request->get("search")."%")
                    ->orWhere("city", "like", "%".$request->get("search")."%")
                    ->orWhere("state", "like", "%".$request->get("search")."%")
                    ->orderBy('id','DESC')->paginate(25);
        }
        else {
            $data = ClientO::orderBy('id','DESC')->paginate(25);
        }
        return [
            'pagination' => [
                'total'         => $data->total(),
                'current_page'  => $data->currentPage(),
                'per_page'      => $data->perPage(),
                'last_page'     => $data->lastPage(),
                'from'          => $data->firstItem(),
                'to'            => $data->lastItem(),
            ],
            "clients" => $data
        ];
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        if($request->get('email') != "") {
            $this->validate($request, [
                "name" => 'required',
                "adress" => 'required',
                "city" => 'required',
                "state" => 'required',
                "email" => 'email|unique:clients_o',
            ]);
        }
        else {
            $this->validate($request, [
                "name" => 'required',
                "adress" => 'required',
                "city" => 'required',
                "state" => 'required',
                //"email" => 'email|unique:clients',
            ]);
        }
        ClientO::create($request->all());
        return;
    }
    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        if($request->get('email') != "") {
            $this->validate($request, [
                "name" => 'required',
                "adress" => 'required',
                "city" => 'required',
                "state" => 'required',
                'sometimes|email|unique:clients_o,email,'.$id,
            ]);
        }
        else {
            $this->validate($request, [
                "name" => 'required',
                "adress" => 'required',
                "city" => 'required',
                "state" => 'required',
                //"email" => 'email|unique:clients',
            ]);
        }
        ClientO::find($id)->update($request->all());
        return;
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $data = ClientO::findOrFail($id);
        $data->delete();
    }
    public function getAll(){
        $clients = ClientO::get();
        return $clients;
    }
}
