
/**
 * First we will load all of this project's JavaScript dependencies which
 * includes Vue and other libraries. It is a great starting point when
 * building robust, powerful web applications using Vue and Laravel.
 */

require('./bootstrap');

window.Vue = require('vue');

/**
 * Next, we will create a fresh Vue application instance and attach it to
 * the page. Then, you may begin adding components to this application
 * or customize the JavaScript scaffolding to fit your unique needs.
 */
Vue.component('v-input', require('./components/vinput.vue'));
Vue.component('table_expenses', require('./components/table_expenses.vue'));
Vue.component('loading', require('./components/loading.vue'));
Vue.component('v-select', require('./components/vselect.vue'));
Vue.component('pagination', require('./components/pagination.vue'));

const app = new Vue({
    el: '#services',
    created: function(){
        this.getExpenses();
    },
    data: {
        expenses: [],
        types: [
            {id: 'Fixed Costs', name: 'Fixed Costs'},
            {id: 'Variable expends', name: 'Variable expends'},
        ],
        pagination: {
            'total': 0,
            'current_page': 0,
            'per_page': 0,
            'last_page': 0,
            'from': 0,
            'to': 0,
        },
        newExpense: {},
        errors: [],
        create: true,
        loading: true,
    },
    methods: {
        getExpenses: function(page){
            var url = "api/expenses?page="+page;
            this.loading = true;
            axios.get(url).then(response => {
                this.expenses = response.data.expenses.data;
                this.pagination = response.data.pagination;
                this.loading = false;
            });
        },
        deleteExpense: function(data){
            var expense = data.item;
            var url = "api/expenses/" + expense.id
            bootbox.confirm("Are you sure do you want delete the expense?", function(result) {
                if(result == true) {
                    axios.delete(url).then(response => {
                        app.getExpenses();
                        toastr.success("The expense was successfully removed");
                    });
                }
            }); 
        },
        showForm: function(){
            this.newExpense = {};
            this.create = true;
            this.errors = [];
            this.refresh('.type');
            jQuery('#create').modal('show');
        },
        executeForm: function(expense){
            if(this.create == true) this.createExpense();
            else this.updateExpense(expense);
                
        },
        createExpense: function(){
           var url = 'api/expenses';
           this.errors = [];
            axios.post(url,{
                type: this.newExpense.type,
                description: this.newExpense.description,
                amount: this.newExpense.amount,
                date: this.newExpense.date,
            }).then(response => {
                this.getExpenses();
                this.newExpense = [];
                this.errors = [];
                jQuery('#create').modal('hide');
                toastr.success("The expense was successfully added");
            }).catch(error => {
                this.errors = error.response.data;
            });
        },
        editExpense: function(data){
            var expense = data.item;
            this.newExpense = {
                type: expense.type,
                description: expense.description,
                amount: expense.amount,
                date: expense.date,
                id: expense.id
            };
            this.create = false;
            this.errors = [];
            alert(this.newExpense.type);
            this.refresh('.type', this.newExpense.type);
            jQuery('#create').modal('show');
        },
        updateExpense: function(expense){
            var url = "api/expenses/" + expense.id;
            axios.put(url,{
                type: this.newExpense.type,
                description: this.newExpense.description,
                amount: this.newExpense.amount,
                date: this.newExpense.date,
            }).then(response => {
                this.getExpenses(this.pagination.current_page);
                this.newExpense = [];
                this.errors = [];
                jQuery('#create').modal('hide');
                toastr.success("The expense was successfully updated");
            }).catch(error => {
                this.errors = error.response.data;
            });
        },
        changePage: function(data){
            var page = data.page;
            this.pagination.current_page = page;
            this.getServices(page);
        },
        refresh: function(parent = "", value = ""){
            if(jQuery(parent+' .bs-select').length) {
                jQuery(parent+' .bs-select').each(function(){
                    jQuery(this).val(value);  
                    jQuery(this).selectpicker("refresh");
                });
            }
        },
        changeModel: function(data){
            this.newExpense.type = data.value;
        },
    },
    mounted: function() {
        jQuery('.date-picker').datepicker({
            orientation: "center",
            autoclose: true
        }).on('changeDate', function(e){
            app.newExpense.date = jQuery('.date-picker input').val();
        });
    }
});
